implementation module menudevice


import	StdBool, StdFunc, StdInt, StdMisc, StdString, StdTuple
import	osmenu
import	processdefaccess, iostate, devicefunctions /* RWS , deviceaccess */, menuaccess, menucreate, menudefaccess
from	StdPSt	import accPIO
// RWS +++
import commondef, menuevent


menudeviceFatalError :: String String -> .x
menudeviceFatalError rule error
	= FatalError rule "menudevice" error


MenuFunctions :: DeviceFunctions i o .l .p
MenuFunctions
	= {	dShow	= menuShow
	  ,	dHide	= menuHide
	  ,	dEvent	= menuEvent
	  ,	dDoIO	= menuIO
	  ,	dOpen	= menuOpen
	  ,	dClose	= menuClose
	  }

menuShow :: !(IOSt .l .p) -> IOSt .l .p
menuShow ioState
	# (activeIO,ioState)	= IOStIsActive ioState
	| not activeIO
	= ioState
	# (tb,ioState)			= getIOToolbox ioState
	# (menus,ioState)		= IOStGetDevice MenuDevice ioState
	  mHs					= MenuSystemStateGetMenuHandles menus
	# (menuBar, tb)			= OSMenuBarSet mHs.mOSMenuBar tb
	  mHs					= {mHs & mOSMenuBar = menuBar}
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (MenuSystemState mHs) ioState
	= ioState

menuClose :: !(IOSt .l .p) -> IOSt .l .p
menuClose ioState
	# (opt_guishare,ioState)= IOStGetGUIShare ioState
	# (menus,ioState)		= IOStGetDevice MenuDevice ioState
	  mHs					= MenuSystemStateGetMenuHandles menus
	# ioState				= appIOToolbox (disposeMenuHandles (isJust opt_guishare) mHs) ioState
	# (ioid,ioState)		= IOStGetIOId ioState
	# (rt,ioState)			= IOStGetReceiverTable ioState
	  rt					= StateMap2 (disposeRIds ioid) mHs.mMenus rt
	# ioState				= IOStSetReceiverTable rt ioState
	# ioState				= IOStRemoveDevice MenuDevice ioState
	= ioState
where
	disposeRIds :: !SystemId !(MenuStateHandle .ps) !ReceiverTable -> ReceiverTable
	disposeRIds ioid (MenuLSHandle {mlsHandle={mItems}}) rt
		= StateMap2 (disposeMenuRIds ioid) mItems rt

menuHide :: !(IOSt .l .p) -> IOSt .l .p
menuHide ioState
	# (activeIO,ioState)	= IOStIsActive ioState
	| not activeIO
	= ioState
	# (menus,ioState)		= IOStGetDevice MenuDevice ioState
	  mHs					= MenuSystemStateGetMenuHandles menus
	# (tb,ioState)			= getIOToolbox ioState
	# tb					= OSMenuBarClear tb
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (MenuSystemState mHs) ioState
	= ioState


/*	Opening menus:
	Note:	all interactive processes have atleast the AppleMenu to identify the 
			process, and is used for checking whether the process is active
			(see IOStIsActive further down this module).
			If the process is a subprocess, then the ioguishare of its IOSt
			contains the list to the Mac toolbox menu system.
*/
menuOpen :: !(IOSt .l .p) -> IOSt .l .p
menuOpen ioState
	# (ioInterface,ioState)	= IOStGetDocumentInterface ioState
	  bound					= menuBound ioInterface
/* RWS +++
	  (opt_guishare,ioState)= IOStGetGUIShare ioState
	| isJust opt_guishare
	= IOStSetDevice menus ioState
	with
		guishare			= fromJust opt_guishare
		mList				= guishare.shareMList
		appleH				= guishare.shareAppleH

		menus				= MenuSystemState
								{	mMenus		= []
								,	mKeys		= []
								,	mMList		= mList
								,	mMenuIds	= [0..]
								,	mEnabled	= SystemAble
								,	mNrMenuBound= bound
								,	mDoASync	= False
								}
*/	# (tb,ioState)			= getIOToolbox ioState
	# (menuBar,tb)			= OSMenuBarNew tb
	# tb					= OSMenuBarClear tb		
	  mHs					= 	{	mMenus		= []
								,	mKeys		= []
								,	mOSMenuBar	= menuBar
								,	mMenuIds	= [0..]
								,	mEnabled	= SystemAble
								,	mNrMenuBound= bound
								,	mDoASync	= False
								}
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (MenuSystemState mHs) ioState
	= ioState
where
	menuBound :: !DocumentInterface -> Bound
	menuBound NDI = Finite 0
	menuBound SDI = Infinite
	menuBound MDI = Infinite


menuIO :: OSSleepTime !(DeviceEvent i o) !(PSt .l .p) -> (OSSleepTime,!DeviceEvent i o,!PSt .l .p)

menuIO sleepTime receiverEvent=:(ReceiverEvent msgEvent) pState
	= (sleepTime,ReceiverEvent msgEvent1,pState2)
where
	(mDevice,ioState)			= IOStGetDevice MenuDevice pState.io
	menus						= MenuSystemStateGetMenuHandles mDevice
	ioState1					= IOStSetDevice (MenuSystemState menus1) ioState
	pState1						= {pState & io=ioState1}
	(msgEvent1,menus1,pState2)	= menuMsgIO msgEvent menus pState1
	
	menuMsgIO :: !(MsgEvent i o) !(MenuHandles (PSt .l .p)) (PSt .l .p) -> (!MsgEvent i o,!MenuHandles (PSt .l .p),PSt .l .p)
	menuMsgIO msgEvent menus=:{mMenus=mHs} pState
		# (msgEvent,mHs,pState)	= menusMsgIO (getMsgEventRecLoc msgEvent).rlParentId msgEvent mHs pState
		= (msgEvent,{menus & mMenus=mHs},pState)
	where
		menusMsgIO :: !Id !(MsgEvent i o) ![MenuStateHandle (PSt .l .p)] (PSt .l .p)
					   -> (!MsgEvent i o, ![MenuStateHandle (PSt .l .p)], PSt .l .p)
		menusMsgIO menuId msgEvent msHs pState
			| isEmpty msHs
				= menudeviceFatalError "menuIO _ (ReceiverEvent _) _" "menu could not be found"
			# (msH,msHs)				= HdTl msHs
			  (id,msH)					= menuStateHandleGetMenuId msH
			| id==menuId
				# (msgEvent,msH,pState)	= menuStateMsgIO msgEvent msH pState
				= (msgEvent,[msH:msHs],pState)
			# (msgEvent,msHs,pState)	= menusMsgIO menuId msgEvent msHs pState
			| otherwise
				= (msgEvent,[msH:msHs],pState)

menuIO sleepTime deviceEvent=:(MenuTraceEvent info) pState
	= (sleepTime,deviceEvent,pState2)
where
	(mDevice,ioState)	= IOStGetDevice MenuDevice pState.io
	menus				= MenuSystemStateGetMenuHandles mDevice
	ioState1			= IOStSetDevice (MenuSystemState menus1) ioState
	pState1				= {pState & io=ioState1}
	(menus1,pState2)	= menuTraceIO info menus pState1
	
	menuTraceIO :: !MenuTraceInfo !(MenuHandles (PSt .l .p)) (PSt .l .p) -> (!MenuHandles (PSt .l .p),PSt .l .p)
	menuTraceIO info=:{mtId} menus=:{mMenus=mHs} pState
		# (mHs,pState)	= menusTraceIO mtId info mHs pState
		= ({menus & mMenus=mHs},pState)
	where
		menusTraceIO :: !Id !MenuTraceInfo ![MenuStateHandle (PSt .l .p)] (PSt .l .p) -> (![MenuStateHandle (PSt .l .p)],PSt .l .p)
		menusTraceIO menuId info msHs pState
			| isEmpty msHs
				= menudeviceFatalError "menuIO _ (MenuTraceEvent _) _" "menu could not be found"
			# (msH,msHs)		= HdTl msHs
			  (id, msH)			= menuStateHandleGetMenuId msH
			| id==menuId
				# (msH,pState)	= menuStateTraceIO info msH pState
				= ([msH:msHs],pState)
			# (msHs,pState)		= menusTraceIO menuId info msHs pState
			| otherwise
				= ([msH:msHs],pState)

menuIO _ _ _
	= menudeviceFatalError "menuIO" "unexpected DeviceEvent"


/*	Apply the Menu(Mods)Function of a selected menu item.
*/
menuStateTraceIO :: !MenuTraceInfo !(MenuStateHandle (PSt .l .p)) (PSt .l .p) -> (!MenuStateHandle (PSt .l .p),PSt .l .p)
menuStateTraceIO info=:{mtParents} (MenuLSHandle {mlsState=ls,mlsHandle=mH=:{mItems}}) pState
	# (mItems,(ls,pState)) = subMenusTraceIO info mtParents mItems (ls,pState)
	= (MenuLSHandle {mlsState=ls,mlsHandle={mH & mItems=mItems}},pState)
where
	//	subMenusTraceIO finds the final submenu that contains the selected menu item and then applies its Menu(Mods)Function.
	subMenusTraceIO :: !MenuTraceInfo ![Int] ![MenuElementHandle .ls .ps] !(.ls,.ps)
										 -> (![MenuElementHandle .ls .ps], (.ls,.ps))
	subMenusTraceIO info [] itemHs ls_ps
		# (_,itemHs,ls_ps)	= menuElementsTraceIO info.mtItemNr info 0 itemHs ls_ps
		= (itemHs,ls_ps)
	subMenusTraceIO info [subIndex:subIndices] itemHs ls_ps
		# (_,itemHs,ls_ps)	= subMenuTraceIO subIndex info subIndices 0 itemHs ls_ps
		= (itemHs,ls_ps)
	where
		subMenuTraceIO :: !Int !MenuTraceInfo ![Int] !Int ![MenuElementHandle .ls .ps] !(.ls,.ps)
												 -> (!Int,![MenuElementHandle .ls .ps], (.ls,.ps))
		subMenuTraceIO parentIndex info parentsIndex zIndex [itemH:itemHs] ls_ps
			# (zIndex,itemH,ls_ps)	= subMenuTraceIO` parentIndex info parentsIndex zIndex itemH ls_ps
			| parentIndex<zIndex
			= (zIndex,[itemH:itemHs],ls_ps)
			# (zIndex,itemHs,ls_ps)	= subMenuTraceIO parentIndex info parentsIndex zIndex itemHs ls_ps
			= (zIndex,[itemH:itemHs],ls_ps)
		where
			subMenuTraceIO` :: !Int !MenuTraceInfo ![Int] !Int !(MenuElementHandle .ls .ps) !(.ls,.ps)
													  -> (!Int, !MenuElementHandle .ls .ps,  (.ls,.ps))
			subMenuTraceIO` parentIndex info parentsIndex zIndex itemH=:(SubMenuHandle subH=:{mSubItems}) ls_ps
				| parentIndex<>zIndex
					= (zIndex+1,itemH,ls_ps)
				# (itemHs,ls_ps)	= subMenusTraceIO info parentsIndex mSubItems ls_ps
				| otherwise
					= (zIndex+1,SubMenuHandle {subH & mSubItems=itemHs},ls_ps)
			subMenuTraceIO` parentIndex info parentsIndex zIndex (RadioMenuHandle itemH=:{mRadioItems}) ls_ps
				# (nrRadios,itemHs)	= Ulength mRadioItems
				= (zIndex+nrRadios,RadioMenuHandle {itemH & mRadioItems=itemHs},ls_ps)
			subMenuTraceIO` parentIndex info parentsIndex zIndex itemH=:(MenuItemHandle _) ls_ps
				= (zIndex+1,itemH,ls_ps)
			subMenuTraceIO` parentIndex info parentsIndex zIndex (MenuListLSHandle itemHs) ls_ps
				# (zIndex,itemHs,ls_ps)	= subMenuTraceIO parentIndex info parentsIndex zIndex itemHs ls_ps
				= (zIndex,MenuListLSHandle itemHs,ls_ps)
			subMenuTraceIO` parentIndex info parentsIndex zIndex (MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs}) (ls,ps)
				# (zIndex,itemHs,((ls1,ls),ps))	= subMenuTraceIO parentIndex info parentsIndex zIndex itemHs ((ls1,ls),ps)
				= (zIndex,MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs},(ls,ps))
			subMenuTraceIO` parentIndex info parentsIndex zIndex (MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs}) (ls,ps)
				# (zIndex,itemHs,(ls1,ps))	= subMenuTraceIO parentIndex info parentsIndex zIndex itemHs (ls1,ps)
				= (zIndex,MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs},(ls,ps))
			subMenuTraceIO` _ _ _ zIndex itemH ls_ps
				= (zIndex,itemH,ls_ps)
		subMenuTraceIO _ _ _ zIndex itemHs ls_ps
			= (zIndex,itemHs,ls_ps)
	
	//	menuElementsTraceIO applies the Menu(Mods)Function of the menu item at index itemIndex to the context state.
	menuElementsTraceIO :: !Int !MenuTraceInfo !Int ![MenuElementHandle .ls .ps] !(.ls,.ps)
										   -> (!Int,![MenuElementHandle .ls .ps], (.ls,.ps))
	menuElementsTraceIO itemIndex info zIndex [itemH:itemHs] ls_ps
		# (zIndex,itemH,ls_ps)	= menuElementTraceIO itemIndex info zIndex itemH ls_ps
		| itemIndex<zIndex
		= (zIndex,[itemH:itemHs],ls_ps)
		# (zIndex,itemHs,ls_ps)	= menuElementsTraceIO itemIndex info zIndex itemHs ls_ps
		= (zIndex,[itemH:itemHs],ls_ps)
	where
		menuElementTraceIO :: !Int !MenuTraceInfo !Int !(MenuElementHandle .ls .ps) !(.ls,.ps)
											  -> (!Int, !MenuElementHandle .ls .ps,  (.ls,.ps))
		menuElementTraceIO itemIndex info zIndex itemH=:(MenuItemHandle {mItemAtts}) (ls,ps)
			| itemIndex<>zIndex || not hasFun
				= (zIndex+1,itemH,  (ls,ps))
				= (zIndex+1,itemH,f (ls,ps))
		where
			(hasFun,fAtt)	= Select isEitherFun undef mItemAtts
			f				= if (ismenufunction fAtt)	(getmenufunction fAtt)
														(getmenumodsfunction fAtt info.mtModifiers)
			isEitherFun f	= ismenufunction f || ismenumodsfunction f
		menuElementTraceIO itemIndex info zIndex (RadioMenuHandle radioH=:{mRadioIndex,mRadioItems}) ls_ps
			# (nrRadios,itemHs)	= Ulength mRadioItems
			| itemIndex>zIndex+nrRadios
				// Selected item is not one of these radio items
				= (zIndex+nrRadios,RadioMenuHandle radioH,ls_ps)
			# (_,itemHs,ls_ps)	= menuElementsTraceIO itemIndex info zIndex itemHs ls_ps
			| otherwise
				= (zIndex+nrRadios,RadioMenuHandle {radioH & mRadioIndex=itemIndex-zIndex+1,mRadioItems=itemHs},ls_ps)
		menuElementTraceIO itemIndex info zIndex itemH=:(SubMenuHandle _) ls_ps
			= (zIndex+1,itemH,ls_ps)
		menuElementTraceIO itemIndex info zIndex (MenuListLSHandle itemHs) ls_ps
			# (zIndex,itemHs,ls_ps) = menuElementsTraceIO itemIndex info zIndex itemHs ls_ps
			= (zIndex,MenuListLSHandle itemHs,ls_ps)
		menuElementTraceIO itemIndex info zIndex (MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs}) (ls,ps)
			# (zIndex,itemHs,((ls1,ls),ps)) = menuElementsTraceIO itemIndex info zIndex itemHs ((ls1,ls),ps)
			= (zIndex,MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs},(ls,ps))
		menuElementTraceIO itemIndex info zIndex (MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs}) (ls,ps)
			# (zIndex,itemHs,(ls1,ps)) = menuElementsTraceIO itemIndex info zIndex itemHs (ls1,ps)
			= (zIndex,MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs},(ls,ps))
		menuElementTraceIO _ _ zIndex itemH ls_ps
			= (zIndex,itemH,ls_ps)
	menuElementsTraceIO _ _ zIndex itemHs ls_ps
		= (zIndex,itemHs,ls_ps)


/*	menuStateMsgIO handles all message events.
*/
menuStateMsgIO :: !(MsgEvent i o) !(MenuStateHandle (PSt .l .p)) (PSt .l .p) -> (!MsgEvent i o,!MenuStateHandle (PSt .l .p),PSt .l .p)
menuStateMsgIO msgEvent msH=:(MenuLSHandle mlsH=:{mlsState=ls,mlsHandle=mH}) pState
	= (msgEvent1,MenuLSHandle {mlsH & mlsState=ls1,mlsHandle=mH1},pState1)
where
	recLoc							= getMsgEventRecLoc msgEvent
	rId								= recLoc.rlReceiverId
	action							= case msgEvent of
										(QASyncMessage msg)	-> menuQASyncIO rId msg
										( ASyncMessage msg) -> menuASyncIO  rId msg
										(  SyncMessage msg) -> menuSyncIO   rId msg
	(msgEvent1,mH1,(ls1,pState1))	= action mH (ls,pState)

	//	menuQASyncIO queues an asynchronous message in the message queue of the indicated receiver menu element.
	menuQASyncIO :: !Id !(QASyncMessage i) !(MenuHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,!MenuHandle .ls .ps,(.ls,.ps))
	menuQASyncIO rId msg mH=:{mItems} ls_ps
		= (QASyncMessage msg,{mH & mItems=itemHs},ls_ps)
	where
		(_,itemHs)	= elementsQASyncIO rId msg.qasmMsg mItems
		
		elementsQASyncIO :: !Id m ![MenuElementHandle .ls .ps] -> (!Bool,![MenuElementHandle .ls .ps])
		elementsQASyncIO rId msg [itemH:itemHs]
			# (done,itemH)	= elementQASyncIO rId msg itemH
			| done
			= (done,[itemH:itemHs])
			# (done,itemHs)	= elementsQASyncIO rId msg itemHs
			= (done,[itemH:itemHs])
		where
			elementQASyncIO :: !Id m !(MenuElementHandle .ls .ps) -> (!Bool,!MenuElementHandle .ls .ps)
			elementQASyncIO rId msg mrH=:(MenuReceiverHandle itemH=:{mReceiverHandle=rH})
				| rId<>rH.rId
				= (False,mrH)
				= (True,MenuReceiverHandle {itemH & mReceiverHandle=receiverAddASyncMessage rId msg rH})
			elementQASyncIO rId msg (SubMenuHandle itemH=:{mSubItems=itemHs})
				# (done,itemHs)	= elementsQASyncIO rId msg itemHs
				= (done,SubMenuHandle {itemH & mSubItems=itemHs})
			elementQASyncIO rId msg (MenuListLSHandle itemHs)
				# (done,itemHs)	= elementsQASyncIO rId msg itemHs
				= (done,MenuListLSHandle itemHs)
			elementQASyncIO rId msg (MenuExtendLSHandle	mExH=:{mExtendItems=itemHs})
				# (done,itemHs)	= elementsQASyncIO rId msg itemHs
				= (done,MenuExtendLSHandle {mExH & mExtendItems=itemHs})
			elementQASyncIO rId msg (MenuChangeLSHandle	mChH=:{mChangeItems=itemHs})
				# (done,itemHs)	= elementsQASyncIO rId msg itemHs
				= (done,MenuChangeLSHandle {mChH & mChangeItems=itemHs})
			elementQASyncIO rId msg itemH
				= (False,itemH)
		elementsQASyncIO _ _ _
			= (False,[])

	//	menuASyncIO handles the first asynchronous message in the message queue of the indicated receiver menu element.
	menuASyncIO :: !Id !ASyncMessage !(MenuHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,!MenuHandle .ls .ps,(.ls,.ps))
	menuASyncIO rId msg mH=:{mItems} ls_ps
		= (ASyncMessage msg,{mH & mItems=itemHs},ls_ps1)
	where
		(_,itemHs,ls_ps1)	= elementsASyncIO rId mItems ls_ps
		
		elementsASyncIO :: !Id ![MenuElementHandle .ls .ps] (.ls,.ps) -> (!Bool,![MenuElementHandle .ls .ps],(.ls,.ps))
		elementsASyncIO rId [itemH:itemHs] ls_ps
			# (done,itemH,ls_ps)	= elementASyncIO rId itemH ls_ps
			| done
			= (done,[itemH:itemHs],ls_ps)
			# (done,itemHs,ls_ps)	= elementsASyncIO rId itemHs ls_ps
			= (done,[itemH:itemHs],ls_ps)
		where
			elementASyncIO :: !Id !(MenuElementHandle .ls .ps) (.ls,.ps) -> (!Bool,!MenuElementHandle .ls .ps,(.ls,.ps))
			elementASyncIO rId mrH=:(MenuReceiverHandle itemH=:{mReceiverHandle=rH}) ls_ps
				| rId<>rH.rId
				= (False,mrH,ls_ps)
				# (rH,ls_ps)	= receiverASyncIO rH ls_ps
				= (True,MenuReceiverHandle {itemH & mReceiverHandle=rH},ls_ps)
			where
				receiverASyncIO :: !(ReceiverHandle .ls .ps) (.ls,.ps) -> (!ReceiverHandle .ls .ps,(.ls,.ps))
				receiverASyncIO rH=:{rASMQ=[msg:msgs],rFun} ls_ps
					# (ls,_,ps)	= rFun msg ls_ps
					= ({rH & rASMQ=msgs},(ls,ps))
				receiverASyncIO _ _
					= menudeviceFatalError "receiverASyncIO" "unexpected empty asynchronous message queue"
			elementASyncIO rId (SubMenuHandle itemH=:{mSubItems=itemHs}) ls_ps
				# (done,itemHs,ls_ps)	= elementsASyncIO rId itemHs ls_ps
				= (done,SubMenuHandle {itemH & mSubItems=itemHs},ls_ps)
			elementASyncIO rId (MenuListLSHandle itemHs) ls_ps
				# (done,itemHs,ls_ps)	= elementsASyncIO rId itemHs ls_ps
				= (done,MenuListLSHandle itemHs,ls_ps)
			elementASyncIO rId (MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs}) (ls,ps)
				# (done,itemHs,((ls1,ls),ps))	= elementsASyncIO rId itemHs ((ls1,ls),ps)
				= (done,MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs},(ls,ps))
			elementASyncIO rId (MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs}) (ls,ps)
				# (done,itemHs,(ls1,ps))	= elementsASyncIO rId itemHs (ls1,ps)
				= (done,MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs},(ls,ps))
			elementASyncIO _ itemH ls_ps
				= (False,itemH,ls_ps)
		elementsASyncIO _ _ ls_ps
			= (False,[],ls_ps)

	//	menuSyncIO lets the indicated receiver control handle the synchronous message.
	menuSyncIO :: !Id !(SyncMessage i o) !(MenuHandle .ls .ps) (.ls,.ps) -> (!MsgEvent i o,MenuHandle .ls .ps,(.ls,.ps))
	menuSyncIO r2Id msg mH=:{mItems} ls_ps
		= (SyncMessage msg1,{mH & mItems=itemHs},ls_ps1)
	where
		(_,msg1,itemHs,ls_ps1)	= elementsSyncIO r2Id msg mItems ls_ps
		
		elementsSyncIO :: !Id !(SyncMessage i o) ![MenuElementHandle .ls .ps] (.ls,.ps)
					 -> (!Bool,!SyncMessage i o,  [MenuElementHandle .ls .ps],(.ls,.ps))
		elementsSyncIO r2Id msg [itemH:itemHs] ls_ps
			# (done,msg,itemH,ls_ps)	= elementSyncIO r2Id msg itemH ls_ps
			| done
			= (done,msg,[itemH:itemHs],ls_ps)
			# (done,msg,itemHs,ls_ps)	= elementsSyncIO r2Id msg itemHs ls_ps
			= (done,msg,[itemH:itemHs],ls_ps)
		where
			elementSyncIO :: !Id !(SyncMessage i o) !(MenuElementHandle .ls .ps) (.ls,.ps)
						-> (!Bool,!SyncMessage i o,   MenuElementHandle .ls .ps, (.ls,.ps))
			elementSyncIO rId msg mrH=:(MenuReceiverHandle itemH=:{mReceiverHandle=rH}) ls_ps
				| rId<>rH.rId
				= (False,msg,mrH,ls_ps)
				# (msg,rH,ls_ps)	= receiverSyncIO msg rH ls_ps
				= (True,msg,MenuReceiverHandle {itemH & mReceiverHandle=rH},ls_ps)
			where
				receiverSyncIO :: !(SyncMessage i o) !(ReceiverHandle .ls .ps) (.ls,.ps)
							   -> (!SyncMessage i o,   ReceiverHandle .ls .ps, (.ls,.ps))
				receiverSyncIO msg rH ls_ps
					# (response,rH,ls_ps)	= receiverHandleSyncMessage msg rH ls_ps
					= ({msg & smResp=response},rH,ls_ps)
			elementSyncIO rId msg (SubMenuHandle itemH=:{mSubItems=itemHs}) ls_ps
				# (done,msg,itemHs,ls_ps)	= elementsSyncIO rId msg itemHs ls_ps
				= (done,msg,SubMenuHandle {itemH & mSubItems=itemHs},ls_ps)
			elementSyncIO rId msg (MenuListLSHandle itemHs) ls_ps
				# (done,msg,itemHs,ls_ps)	= elementsSyncIO rId msg itemHs ls_ps
				= (done,msg,MenuListLSHandle itemHs,ls_ps)
			elementSyncIO rId msg (MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs}) (ls,ps)
				# (done,msg,itemHs,((ls1,ls),ps))	= elementsSyncIO rId msg itemHs ((ls1,ls),ps)
				= (done,msg,MenuExtendLSHandle {mExtendLS=ls1,mExtendItems=itemHs},(ls,ps))
			elementSyncIO rId msg (MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs}) (ls,ps)
				# (done,msg,itemHs,(ls1,ps))	= elementsSyncIO rId msg itemHs (ls1,ps)
				= (done,msg,MenuChangeLSHandle {mChangeLS=ls1,mChangeItems=itemHs},(ls,ps))
			elementSyncIO rId msg itemH ls_ps
				= (False,msg,itemH,ls_ps)
		elementsSyncIO _ msg _ ls_ps
			= (False,msg,[],ls_ps)


/* RWS +++
//	Change the title of the Apple menu:

IOStSetAppleMenuTitle :: !Bool !String !(IOSt .l .p) -> IOSt .l .p
IOStSetAppleMenuTitle isSubProcess appName ioState
	| isSubProcess || appName==""
	= ioState
	# (menus,ioState)	= IOStGetDevice MenuDevice ioState
	  (mHs,menuHs)		= MenuHandlesGetMenuStateHandles (MenuSystemStateGetMenuHandles menus)
	  (appleH,others)	= HdTl mHs
	  (apple,appleH)	= menuStateHandleGetHandle appleH
	  ioState			= appIOToolbox (SetItem apple 1 ("About "+++appName+++"...")) ioState
	  ioState			= IOStSetDevice (MenuSystemState {menuHs & mMenus=[appleH:others]}) ioState
	= ioState
*/

/*	Check if the interactive process is active:
	Note:	this test depends on the fact that every interactive process has an AppleMenu,
			with mac menu ID AppleMenuId. This is taken care of by the creation
			of the interactive process (see menuOpen above).
*/
IOStIsActive :: !(IOSt .l .p) -> (!Bool, !IOSt .l .p)
IOStIsActive ioState
/* RWS +++
	# (globalHandle,ioState)= accIOToolbox (GetMHandle AppleMenuId) ioState
	  (menus,ioState)		= IOStGetDevice MenuDevice ioState
	  (mHs,menuHs)			= MenuHandlesGetMenuStateHandles (MenuSystemStateGetMenuHandles menus)
	  (appleH,others)		= HdTl mHs
	  (apple,appleH1)		= menuStateHandleGetHandle appleH
	  ioState				= IOStSetDevice (MenuSystemState {menuHs & mMenus=[appleH1:others]}) ioState
	= (apple==globalHandle,ioState)
*/	= (True,ioState)


/*	Activate the interactive process:	*/

ActivateMenuSystem :: !(IOSt .l .p) -> IOSt .l .p
ActivateMenuSystem ioState
	# ioState			= SelectIOSt ioState
	  (menus,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles menus
	  (tb,ioState)		= getIOToolbox ioState
	  (menuBar, tb)		= OSMenuBarSet mHs.mOSMenuBar tb
	  ioState			= setIOToolbox	tb ioState
	  ioState			= IOStSetDevice (MenuSystemState {mHs & mOSMenuBar=menuBar}) ioState
	= ioState
